'MMEDIT!!! Basic Version = Micromite_5.05.01
'MMEDIT!!! Port = COM14:38400:10,300
'MMEDIT!!! Device = Micromite_5.05.01
OPTION EXPLICIT
OPTION BASE 0
OPTION AUTORUN ON
DIM INTEGER JUNK,SCROLL,J
Const C.B=RGB(BLACK)
Const C.F=RGB(WHITE)
CONST C.OK=RGB(GREEN)
Const C.WARN=RGB(yellow)
Const C.ERROR=RGB(RED)
Const C.BUTTON=RGB(cyan)
Const C.TITLE=RGB(192,192,192)
CONST C.FOCUS=RGB(yellow)
Const AUDIO_INIT=0
Const AUDIO_SET_PTR=1
Const AUDIO_PLAY=2
Const AUDIO_GET_STATE=4
Const AUDIO_LPC_PTR = 8
Const AUDIO_LPC_START = 9
CONST LPC_SET_CONST_PTR = 11
CONST GPS_SET=48
CONST GPS_PARSE=49
CONST GPS_PARSER0=50
CONST GPS_PARSER1=51
CONST GPS_PARSER2=52
CONST GPS_PARSER3=53
CONST GPS_GET_DEG=61
CONST GPS_GET_MIN=62
CONST GPS_GET_SEC=63
Const AUDIO_STOPPED=0
JUNK=COMBINED(AUDIO_INIT)
JUNK=COMBINED(LPC_SET_CONST_PTR,PEEK(CFUNADDR LPC_CONST))
CONST LDR_PIN=4
SETPIN LDR_PIN,AIN
CONST BAT_PIN=5
SETPIN BAT_PIN,AIN
CONST BAT_CTL=9
SETPIN BAT_CTL,DOUT
PIN(BAT_CTL)=1
DIM INTEGER BL_TGT,VOL_TGT
DIM INTEGER BL_ACT,VOL_ACT
DIM INTEGER BL_TM,VOL_TM
BL_TM=TIMER
VOL_TM=TIMER
BL_ACT=100
VOL_ACT=0
CONST BL_STEP=100
CONST VOL_STEP=100
DIM INTEGER SND_ON
SND_ON=1
CONST MCP4251_CS=10
SETPIN MCP4251_CS,DOUT
PIN(MCP4251_CS)=1
SET_VOLUME(VOL_ACT)
DIM STRING GNSS LENGTH 3
GNSS="$GP"
Open "COM1:9600" As #1
DIM STRING GPS_DATA
GPS_DATA=""
JUNK=COMBINED(GPS_SET,PEEK(VARADDR GPS_DATA))
DIM STRING GPRMC_PARSE(20) LENGTH 20
JUNK=COMBINED(GPS_PARSER0,PEEK(VARADDR GPRMC_PARSE()))
DIM STRING GPGSA_PARSE(20) LENGTH 20
JUNK=COMBINED(GPS_PARSER1,PEEK(VARADDR GPGSA_PARSE()))
DIM STRING GPGSV_PARSE(20) LENGTH 20
JUNK=COMBINED(GPS_PARSER2,PEEK(VARADDR GPGSV_PARSE()))
DIM STRING GPGGA_PARSE(20) LENGTH 20
JUNK=COMBINED(GPS_PARSER3,PEEK(VARADDR GPGGA_PARSE()))
DIM STRING KEYS_LOWER,KEYS_UPPER,KEYS,KEYS_NUMBER
KEYS_LOWER="1234567890-=qwertyuiop[]asdfghjkl;' \zxcvbnm,./`"
KEYS_UPPER="!@#$%^&*()_+QWERYTUIOP{}ASDFGHJKL:"+CHR$(34)+" |ZXCVBNM<>?~"
KEYS_NUMBER="`-789<'.456 "+chr$(34)+"0123 "
KEYS=KEYS_LOWER
CONST BUTTON_COUNT=25
DIM B_COORD(BUTTON_COUNT,4) AS INTEGER
DIM BUTTON_TEXT(BUTTON_COUNT) AS STRING LENGTH 30
DIM FLOAT SUPPLY_VOLTAGE,GPS_OK,ALT,SAT_COUNT,LATITUDE,LONGITUDE,SPEED,TRACK
TRACK=0
DIM STRING GPS_TIME,GPS_DATE
GET_BATTERY
GPS_OK=0
DIM INTEGER LAST_GPS_TIME
LAST_GPS_TIME=0
CONST GPS_TIMEOUT=5000
CONST TILE_FULL_DRAW=1
CONST TILE_REDRAW=2
CONST TILE_W=3
CONST TILE_H=4
CONST TILE_PRESS=5
CONST TILE_TYPE_COUNT=24
CONST TILE_TITLE_LENGTH=14
DIM STRING T_TYPE(TILE_TYPE_COUNT) LENGTH TILE_TITLE_LENGTH
T_TYPE(1)="HEADING"
T_TYPE(2)="COMPASS"
T_TYPE(3)="SMALL SPEED"
T_TYPE(4)="LATITUDE"
T_TYPE(5)="LONGITUDE"
T_TYPE(6)="ALTITUDE"
T_TYPE(7)="BEARING"
T_TYPE(8)="LARGE SPEED"
T_TYPE(9)="PAGE 1"
T_TYPE(10)="PAGE 2"
T_TYPE(11)="PAGE 3"
T_TYPE(12)="PAGE 4"
T_TYPE(13)="POI COMPASS"
T_TYPE(14)="DIST TO POI"
T_TYPE(15)="ALT DIFF POI"
T_TYPE(16)="SCHOOL TIME"
T_TYPE(17)="POI PAGE"
T_TYPE(18)="SETTINGS PAGE"
T_TYPE(19)="SLEEP"
T_TYPE(20)="VOLUME"
T_TYPE(21)="CURR POI NAME"
T_TYPE(22)="POI HEADING"
T_TYPE(23)="AVE SPEED"
DIM FLOAT TILE_CLT
TILE_CLT=0
DIM FLOAT TILE_C2LT
TILE_C2LT=0
DIM FLOAT TILE_CPLT
TILE_CPLT=0
DIM INTEGER TILE_AVSPD_TOTAL,TILE_AVSPD_LAST_T,TILE_AVSPD_INIT_T
TILE_AVSPD_TOTAL=0
TILE_AVSPD_INIT_T=TIMER
TILE_AVSPD_LAST_T=TILE_AVSPD_INIT_T
CONST PG_CNT=4
CONST ITEM_COUNT=6
CONST PAGE_TITLE_LENGTH=15
DIM STRING PAGE_TITLES(PG_CNT) LENGTH PAGE_TITLE_LENGTH
DIM INTEGER PAGE_TILES(PG_CNT,ITEM_COUNT),PG_T_X(PG_CNT,ITEM_COUNT),PG_T_Y(PG_CNT,ITEM_COUNT)
DIM INTEGER PG_T_W(PG_CNT,ITEM_COUNT),PG_T_H(PG_CNT,ITEM_COUNT)
CONST POI_COUNT=21
CONST POI_NAME_LENGTH=15
DIM FLOAT POI_LAT(POI_COUNT),POI_LON(POI_COUNT),POI_ALT(POI_COUNT)
DIM FLOAT POI_D(POI_COUNT),POI_H(POI_COUNT)
DIM FLOAT CURR_POI_D,CURR_POI_H
DIM STRING POI_NAME(POI_COUNT) LENGTH POI_NAME_LENGTH
DIM FLOAT B_UPPER,B_LOWER
DIM INTEGER BAT_TO,BATTERY_OK_TIME,LAST_BATTERY_UPDATE,CURR_POI,IND
B_UPPER=4.4
B_LOWER=3.8
BAT_TO=30
CURR_POI=0
CONST LL_DMS_FORMAT=0
CONST LL_DD_FORMAT=1
CONST LL_GPS_FORMAT=2
CONST LL_NEGSIGN=0
CONST LL_SIGN=1
CONST LL_NSEW=2
CONST DIST_METRE=0
CONST DIST_F=1
CONST DIST_KM=2
CONST DIST_MILE=3
CONST DIST_NM=4
CONST DIST_FL=5
CONST SPEED_MS=0
CONST SPEED_KPH=1
CONST SPEED_MPH=2
CONST SPEED_KNOTS=3
DIM FLOAT U_MULT(6),D_MULT(6)
U_MULT(SPEED_MS)=1
U_MULT(SPEED_KPH)=3.6
U_MULT(SPEED_MPH)=2.23694
U_MULT(SPEED_KNOTS)=1.94384
U_MULT(4)=1
U_MULT(5)=1
D_MULT(DIST_METRE)=1
D_MULT(DIST_F)=3.28084
D_MULT(DIST_KM)=0.001
D_MULT(DIST_MILE)=1
D_MULT(DIST_NM)=0.000621371
D_MULT(DIST_FL)=0.0328084
DIM STRING FMTS(5,6) LENGTH 7
FMTS(0,0)="D`M'S"+CHR$(34)
FMTS(0,1)="DDD.DD"
FMTS(0,2)="DMM.MM"
FMTS(1,0)="- only"
FMTS(1,1)="- or +"
FMTS(1,2)="NS/EW"
FMTS(2,0)="metres"
FMTS(2,1)="feet"
FMTS(2,2)="km"
FMTS(2,3)="miles"
FMTS(2,4)="NM"
FMTS(2,5)="FLEVEL"
FMTS(3,0)="m/s"
FMTS(3,1)="kph"
FMTS(3,2)="mph"
FMTS(3,3)="kts"
FMTS(4,0)="m "
FMTS(4,1)="ft"
FMTS(4,2)="km"
FMTS(4,3)="mi"
FMTS(4,4)="NM"
FMTS(4,5)="FL"
DIM STRING PAD LENGTH 30
PAD="                             "
DIM INTEGER SPD_FMT,LL_FMT,LL_SGN,HD_FMT,VD_FMT,TZONE,DST_ON,T_FMT
SPD_FMT=SPEED_KPH
LL_FMT=LL_DMS_FORMAT
LL_SGN=LL_NSEW
HD_FMT=DIST_METRE
VD_FMT=DIST_METRE
TZONE=600
DST_ON=0
T_FMT=12
DIM FLOAT BL_HI,BL_LO,SP_LO,SP_HI,VOL_HI,VOL_LO
BL_HI=100
BL_LO=20
SP_LO=8.3333333
SP_HI=22.222222
VOL_LO=50
VOL_HI=150
VAR RESTORE
LOAD_TILE_VARIABLES
SAVE_ALL
SET_GNSS
SUB SAVE_ALL
VAR SAVE POI_LAT(),POI_LON(),POI_ALT(),POI_NAME(),B_UPPER,B_LOWER,BAT_TO,SPD_FMT,LL_FMT,LL_SGN,HD_FMT,VD_FMT
VAR SAVE PAGE_TITLES(),PAGE_TILES(),PG_T_X(),PG_T_Y(),CURR_POI,TZONE,DST_ON,T_FMT
VAR SAVE BL_HI,BL_LO,SP_LO,SP_HI,VOL_HI,VOL_LO,SND_ON,GNSS
END SUB
DIM INTEGER NPG
CONST NEXT_SLEEP_PAGE=-8
CONST NEXT_RAW_DATA_PAGE=-7
CONST NEXT_POI_PAGE=-5
CONST NEXT_COMPOSE_PAGE=-4
CONST NEXT_POWER_PAGE=-3
CONST NEXT_SETTINGS_PAGE=-2
CONST NEXT_MAIN_PAGE=-1
NPG=NEXT_MAIN_PAGE
ON ERROR IGNORE
RTC GETTIME
ON ERROR ABORT
REBOOT:
CLS
TEXT 240,100,"SILICON CHIP",CM,8,2,C.F,C.B
TEXT 240,160,"MICROMITE",CM,8,2,C.F,C.B
TEXT 240,220,"GPS COMPUTER",CM,8,2,C.F,C.B
DIM INTEGER BELL(201,5)
JUNK=PEEK(VARADDR BELL())
FOR J=0 TO 8000:POKE BYTE JUNK+4+J,((SIN(J*0.3)+1)*(8000-J))\64:NEXT J
BELL(0,0)=8000
CLS
DO
IF NPG >=0 AND NPG<PG_CNT THEN
TILE_PAGE(NPG)
ELSE IF NPG=NEXT_SLEEP_PAGE THEN
NPG=NEXT_MAIN_PAGE
SLEEP_PAGE
ELSE IF NPG=NEXT_SETTINGS_PAGE THEN
NPG=NEXT_MAIN_PAGE
SETTINGS_PAGE
ELSE IF NPG=NEXT_POWER_PAGE THEN
NPG=NEXT_MAIN_PAGE
POWER_PAGE
ELSE IF NPG=NEXT_COMPOSE_PAGE THEN
NPG=NEXT_MAIN_PAGE
COMPOSE_PAGE
ELSE IF NPG=NEXT_POI_PAGE THEN
NPG=NEXT_MAIN_PAGE
POI_PAGE
ELSE IF NPG=NEXT_RAW_DATA_PAGE THEN
NPG=NEXT_MAIN_PAGE
RAW_DATA_PAGE
ELSE
NPG=NEXT_MAIN_PAGE
MAIN_PAGE
ENDIF
LOOP
GOTO REBOOT:
SUB SLEEP_PAGE
PWM 2,50000,0
CLS(C.TITLE)
DO WHILE TOUCH(X)<0
CPU SLEEP 1
GET_BATTERY
IF SUPPLY_VOLTAGE > B_LOWER THEN
BATTERY_OK_TIME=TIMER
ELSE
IF BAT_TO-((TIMER-BATTERY_OK_TIME)\1000)<0 THEN PIN(BAT_CTL)=0
ENDIF
LOOP
PWM 2,50000,100
DO WHILE TOUCH(X)> -1
LOOP
BL_TM=TIMER
VOL_TM=TIMER
END SUB
SUB POWER_PAGE
PIN(BAT_CTL)=1-PIN(BAT_CTL)
END SUB
SUB POI_PAGE
LOCAL INTEGER DONE,C
DONE=0
IND=0
GET_POI_D
DRAW_POI_PAGE_ALL
DO WHILE(DONE=0)
IDLE(100)
C=CHECKBUTTON(0,11)
IF C>-1 THEN
CHECKRELEASE(C)
IF C=0 THEN DONE=1
IF C=1 THEN IND=ADD_NEW_POI(IND):DRAW_POI_PAGE
IF C=2 THEN IND=ADD_HERE(IND):DRAW_POI_PAGE
IF C=3 AND POI_NAME(IND)<> "" THEN
IF ACCEPT_STRING("Delete "+POI_NAME(IND)+"?")>0 THEN POI_NAME(IND)=""
DRAW_POI_PAGE_ALL
ENDIF
IF C=6 THEN CURR_POI=(IND+POI_COUNT-1) MOD POI_COUNT:DRAW_POI_PAGE
IF C=7 THEN CURR_POI=IND:DRAW_POI_PAGE
IF C=8 THEN CURR_POI=(IND+1) MOD POI_COUNT:DRAW_POI_PAGE
IF C=9 THEN GET_POI_D:DRAW_POI_PAGE
IF C=10 THEN
IND=IND-1
IF IND<0 THEN IND=POI_COUNT-1
DRAW_POI_PAGE
ENDIF
IF C=11 THEN
IND=IND+1
IF IND>POI_COUNT-1 THEN IND=0
DRAW_POI_PAGE
ENDIF
ENDIF
LOOP
END SUB
FUNCTION ADD_NEW_POI(S AS INTEGER)
ADD_NEW_POI=S
LOCAL INTEGER I
FOR I=0 TO POI_COUNT-1
IF POI_NAME((S+I) MOD POI_COUNT)="" THEN ADD_NEW_POI=(S+I) MOD POI_COUNT:EXIT FOR
NEXT I
IF ADD_NEW_POI<0 THEN ADD_NEW_POI=S:MESSAGE_BOX("No free POI slots."):DRAW_POI_PAGE_ALL:EXIT FUNCTION
I=0
DO WHILE I=0
POI_NAME(ADD_NEW_POI)=KEYBOARD_STRING("POI name")
I=ACCEPT_STRING(POI_NAME(ADD_NEW_POI))
LOOP
POI_LAT(ADD_NEW_POI)=GET_LAT_PROMPT()
POI_LON(ADD_NEW_POI)=GET_LON_PROMPT()
I=0
DO WHILE I=0
POI_ALT(ADD_NEW_POI)=VAL(KEYBOARD_NUMBER("Alt("+FMTS(4,VD_FMT)+"):"))/D_MULT(VD_FMT)
I=ACCEPT_STRING(GET_ALT_STRING(POI_ALT(ADD_NEW_POI)))
LOOP
GET_POI_D
DRAW_POI_PAGE_ALL
END FUNCTION
FUNCTION GET_LAT_PROMPT() AS FLOAT
LOCAL INTEGER I
LOCAL STRING S
I=0
DO WHILE I=0
GET_LAT_PROMPT=PARSE_LAT_LON(KEYBOARD_NUMBER("Lat:"))
I=ACCEPT_STRING(GET_LAT_STRING(GET_LAT_PROMPT))
LOOP
END FUNCTION
FUNCTION GET_LON_PROMPT() AS FLOAT
LOCAL INTEGER I
LOCAL STRING S
I=0
DO WHILE I=0
GET_LON_PROMPT=PARSE_LAT_LON(KEYBOARD_NUMBER("Long:"))
I=ACCEPT_STRING(GET_LON_STRING(GET_LON_PROMPT))
LOOP
END FUNCTION
FUNCTION PARSE_LAT_LON(SS AS STRING)
LOCAL STRING P
P=SS
LOCAL INTEGER A,B,C
LOCAL FLOAT D,M,S
A=INSTR(1,P,"`")
B=INSTR(1,P,"'")
C=INSTR(1,P,CHR$(34))
IF A=0 AND B=0 AND C=0 THEN PARSE_LAT_LON=VAL(P):EXIT FUNCTION
IF A=0 THEN
D=0
ELSE
D=VAL(MID$(P,1,A-1))
P=RIGHT$(P,LEN(P)-A)
B=INSTR(1,P,"'")
C=INSTR(1,P,CHR$(34))
ENDIF
IF B=0 THEN
M=0
ELSE
M=VAL(MID$(P,1,B-1))
P=RIGHT$(P,LEN(P)-B)
C=INSTR(1,P,CHR$(34))
ENDIF
IF C=0 THEN
S=0
ELSE
S=VAL(MID$(P,1,C-1))
ENDIF
IF D<0 THEN
PARSE_LAT_LON=D-M/60-S/3600
ELSE
PARSE_LAT_LON=D+M/60+S/3600
ENDIF
IF (RIGHT$(P,1)="S" OR RIGHT$(P,1)="W") AND PARSE_LAT_LON<0 THEN PARSE_LAT_LON=-PARSE_LAT_LON
END FUNCTION
FUNCTION ADD_HERE(S AS INTEGER)
ADD_HERE=-1
LOCAL INTEGER I
FOR I=0 TO POI_COUNT-1
IF POI_NAME((S+I) MOD POI_COUNT)="" THEN ADD_HERE=(S+I) MOD POI_COUNT:EXIT FOR
NEXT I
IF ADD_HERE<0 THEN ADD_HERE=S:MESSAGE_BOX("No free POI slots."):DRAW_POI_PAGE_ALL:EXIT FUNCTION
POI_LAT(ADD_HERE)=LATITUDE
POI_LON(ADD_HERE)=LONGITUDE
POI_ALT(ADD_HERE)=ALT
POI_NAME(ADD_HERE)=LEFT$(GPRMC_PARSE(4),4)+LEFT$(GPRMC_PARSE(5),1)+","+LEFT$(GPRMC_PARSE(6),5)+LEFT$(GPRMC_PARSE(7),1)
I=0
DO WHILE I=0
I=ACCEPT_STRING(POI_NAME(ADD_HERE))
IF I=0 THEN POI_NAME(ADD_HERE)=KEYBOARD_STRING("POI name")
LOOP
GET_POI_D
DRAW_POI_PAGE_ALL
END FUNCTION
SUB DRAW_POI_PAGE_ALL
CLS
PURGE_BUTTONS
TEXT 10,0,"POI EDITOR",LT,8,1,C.TITLE,C.B
DRAWBUTTON(0,0,385,270,90,40,"EXIT")
DRAWBUTTON(1,0,5,30,150,40,"ADD POI")
DRAWBUTTON(2,0,165,30,150,40,"ADD HERE")
DRAWBUTTON(3,0,325,30,150,40,"DELETE")
DRAWBUTTON(6,0,385,126,90,40,"<SET")
DRAWBUTTON(7,0,385,174,90,40,"<SET")
DRAWBUTTON(8,0,385,222,90,40,"<SET")
DRAWBUTTON(9,0,385,78,90,40,"REFR")
DRAWBUTTON(10,0,5,78,30,112,"^")
DRAWBUTTON(11,0,5,198,30,112,"V")
DRAW_POI_PAGE
END SUB
SUB DRAW_POI_PAGE
LOCAL INTEGER C,I
FOR I=-2 TO 2
C=C.TITLE
IF I=0 THEN C=C.FOCUS
IF ((IND+I+POI_COUNT) MOD POI_COUNT)=CURR_POI THEN C=C.OK
DRAW_POI_ENTRY(((IND+I+POI_COUNT) MOD POI_COUNT),40,178+I*48,C)
NEXT I
END SUB
SUB DRAW_POI_ENTRY(N AS INTEGER,X AS INTEGER,Y AS INTEGER,C AS INTEGER)
IF POI_NAME(N)="" THEN
TEXT X,Y,"EMPTY                ",LT,8,1,C,C.B
TEXT X,Y+24,LEFT$(PAD+PAD,42),LT,1,1,C,C.B
ELSE
TEXT X,Y,LEFT$(STR$(N+1)+":"+POI_NAME(N)+PAD,17)+STR$(POI_H(N),3,0)+"`",LT,8,1,C,C.B
TEXT X,Y+24,LEFT$(GET_LAT_STRING(POI_LAT(N))+","+GET_LON_STRING(POI_LON(N))+" "+GET_ALT_STRING(POI_ALT(N))+PAD,31)+GET_DIST_STRING(POI_D(N)),LT,1,1,C,C.B
ENDIF
END SUB
SUB GET_POI_D
LOCAL INTEGER I
FOR I=0 TO POI_COUNT-1
POI_D(I)=GLOBE_D(POI_LAT(I),POI_LON(I))
POI_H(I)=GLOBE_H(POI_LAT(I),POI_LON(I))
NEXT I
END SUB
FUNCTION GLOBE_H(POILAT AS FLOAT,POILON AS FLOAT) AS FLOAT
Local float X,Y,LAT1,LON1,LAT2,LON2
LAT1=Rad(LATITUDE)
LON1=Rad(LONGITUDE)
LAT2=Rad(POILAT)
LON2=Rad(POILON)
Y=SIN(LON2-LON1)*COS(LAT2)
X=COS(LAT1)*SIN(LAT2)-SIN(LAT1)*COS(LAT2)*COS(LON2-LON1)
GLOBE_H=(Deg(ATAN2(Y,X))+1080) MOD 360
END FUNCTION
FUNCTION GLOBE_D(POILAT AS FLOAT,POILON AS FLOAT) AS FLOAT
Local float X,Y,LAT1,LAT2,N,M,A
LAT1=Rad(LATITUDE)
LAT2=Rad(POILAT)
N=RAD(POILAT-LATITUDE)
M=RAD(POILON-LONGITUDE)
A=SIN(M/2)*SIN(M/2)+COS(LAT1)*COS(LAT2)*SIN(N/2)*SIN(N/2)
IF A>1 THEN A=1
N=ATAN2(SQR(A),SQR(1-A))*12756268.69
GLOBE_D=N
END FUNCTION
SUB SETTINGS_PAGE
LOCAL INTEGER DONE,I,C
SCROLL=0
DONE=0
SETTINGS_MAIN_DRAW
DO WHILE(DONE=0)
IDLE(100)
C=CHECKBUTTON(0,19)
IF C>-1 THEN
IF CHECKBUTTON(13,13)=13 THEN MOD_FIELD(-1)
IF CHECKBUTTON(14,14)=14 THEN MOD_FIELD(1)
SETTINGS_DRAW
IDLE_IGNORE_TOUCH(200)
DO WHILE(CHECKBUTTON(13,14)>-1)
IF CHECKBUTTON(13,13)=13 THEN MOD_FIELD(-1)
IF CHECKBUTTON(14,14)=14 THEN MOD_FIELD(1)
SETTINGS_DRAW
IDLE_IGNORE_TOUCH(40)
LOOP
CHECKRELEASE(C)
IF C=0 THEN DONE=1
IF C=1 THEN LL_FMT=(LL_FMT+1) MOD 3
IF C=2 THEN LL_SGN=(LL_SGN+1) MOD 3
IF C=3 THEN HD_FMT=(HD_FMT+1) MOD 6
IF C=4 THEN VD_FMT=(VD_FMT+1) MOD 6
IF C=5 THEN SPD_FMT=(SPD_FMT+1) MOD 4
IF C=6 THEN SAVE_ALL
IF C=7 THEN B_LOWER=B_LOWER-0.1:IF B_LOWER<1 THEN B_LOWER=1
IF C=8 THEN B_LOWER=B_LOWER+0.1:IF B_LOWER>5 THEN B_LOWER=5
IF C=9 THEN B_UPPER=B_UPPER-0.1:IF B_UPPER<1 THEN B_UPPER=1
IF C=10 THEN B_UPPER=B_UPPER+0.1:IF B_UPPER>5 THEN B_UPPER=5
IF C=11 THEN BAT_TO=BAT_TO-15:IF BAT_TO<0 THEN BAT_TO=0
IF C=12 THEN BAT_TO=BAT_TO+15:IF BAT_TO>990 THEN BAT_TO=990
IF C=15 THEN DST_ON=1-DST_ON
IF C=16 THEN SET_TIME
IF C=17 THEN T_FMT=36-T_FMT
IF C=18 THEN SCROLL=(SCROLL+1) MOD 7
IF C=19 THEN SND_ON=1-SND_ON
SETTINGS_DRAW
ENDIF
LOOP
END SUB
SUB MOD_FIELD(D AS INTEGER)
SELECT CASE SCROLL
CASE 0
TZONE=TZONE+D*15
IF TZONE<-900 THEN TZONE=-900
IF TZONE>900 THEN TZONE=900
CASE 1
BL_HI=BL_HI+D
IF BL_HI<1 THEN BL_HI=1
IF BL_HI>100 THEN BL_HI=100
CASE 2
BL_LO=BL_LO+D
IF BL_LO<1 THEN BL_LO=1
IF BL_LO>100 THEN BL_LO=100
CASE 3
SP_HI=SP_HI+D/U_MULT(SPD_FMT)
IF SP_HI<0 THEN SP_HI=0
IF SP_HI>130/U_MULT(SPD_FMT) THEN SP_HI=130/U_MULT(SPD_FMT)
CASE 4
SP_LO=SP_LO+D/U_MULT(SPD_FMT)
IF SP_LO<0 THEN SP_LO=0
IF SP_LO>130/U_MULT(SPD_FMT) THEN SP_LO=130/U_MULT(SPD_FMT)
CASE 5
VOL_HI=VOL_HI+D
IF VOL_HI<0 THEN VOL_HI=0
IF VOL_HI>256 THEN VOL_HI=256
CASE 6
VOL_LO=VOL_LO+D
IF VOL_LO<0 THEN VOL_LO=0
IF VOL_LO>256 THEN VOL_LO=256
END SELECT
END SUB
SUB SHOW_FIELD
LOCAL STRING S1,S2
SELECT CASE SCROLL
CASE 0
IF TZONE<0 THEN
S1="-"+STR$(ABS(TZONE)\60,2,0,"0")+":"+STR$(ABS(TZONE) MOD 60,2,0,"0")
ELSE
S1="+"+STR$(TZONE\60,2,0,"0")+":"+STR$(TZONE MOD 60,2,0,"0")
ENDIF
S2=" TZONE "
CASE 1
S1=STR$(BL_HI,3,0)+"%  "
S2=" BL HI "
CASE 2
S1=STR$(BL_LO,3,0)+"%  "
S2=" BL LO "
CASE 3
S1=STR$(SP_HI*U_MULT(SPD_FMT),3,0)+FMTS(3,SPD_FMT)
S2=" SP HI "
CASE 4
S1=STR$(SP_LO*U_MULT(SPD_FMT),3,0)+FMTS(3,SPD_FMT)
S2=" SP LO "
CASE 5
S1=STR$(VOL_HI,3,0)+"%  "
S2=" VOL HI"
CASE 6
S1=STR$(VOL_LO,3,0)+"%  "
S2=" VOL LO"
END SELECT
TEXT 216,278,S1,LT,8,1,C.FOCUS,C.B
TEXT 43,278,S2,LT,8,1,C.TITLE,C.B
END SUB
SUB SET_TIME
LOCAL INTEGER T(6)
LOCAL INTEGER E
IF GPS_OK<1 THEN MESSAGE_BOX("GPS not ready."):SETTINGS_MAIN_DRAW:EXIT SUB
ON ERROR IGNORE
TIME$=MID$(GPS_TIME,1,2)+":"+MID$(GPS_TIME,3,2)+":"+MID$(GPS_TIME,5,2)
DATE$=MID$(GPS_DATE,1,2)+"-"+MID$(GPS_DATE,3,2)+"-20"+MID$(GPS_DATE,5,2)
T(0)=val(mid$(DATE$,7,4))
T(1)=val(mid$(DATE$,4,2))
T(2)=val(mid$(DATE$,1,2))
T(3)=val(mid$(TIME$,1,2))
T(4)=val(mid$(TIME$,4,2))
T(5)=val(mid$(TIME$,7,2))
RTC SETTIME T(0),T(1),T(2),T(3),T(4),T(5)
E=MM.ERRNO
ON ERROR ABORT
IF E > 0 THEN MESSAGE_BOX("Error:time may not be set."):SETTINGS_MAIN_DRAW:EXIT SUB
MESSAGE_BOX("Time set and saved to RTC."):SETTINGS_MAIN_DRAW
END SUB
SUB SETTINGS_MAIN_DRAW
CLS
PURGE_BUTTONS
TEXT 10,0,"SETTINGS",LT,8,1,C.TITLE,C.B
DRAWBUTTON(0,0,380,270,90,40,"EXIT")
DRAWBUTTON(1,0,0,30,150,40,"L/L FMT")
DRAWBUTTON(2,0,0,78,150,40,"L/L SIGN")
DRAWBUTTON(3,0,0,126,150,40,"HOR DIST")
DRAWBUTTON(4,0,0,174,150,40,"VER DIST")
DRAWBUTTON(5,0,0,222,150,40,"SPEED")
DRAWBUTTON(6,0,380,222,90,40,"SAVE")
DRAWBUTTON(7,0,264,30,40,40,"-")
DRAWBUTTON(8,0,320,30,40,40,"+")
DRAWBUTTON(9,0,264,78,40,40,"-")
DRAWBUTTON(10,0,320,78,40,40,"+")
DRAWBUTTON(11,0,264,126,40,40,"-")
DRAWBUTTON(12,0,320,126,40,40,"+")
DRAWBUTTON(13,0,0,270,40,40,"-")
DRAWBUTTON(14,0,166,270,40,40,"+")
DRAWBUTTON(16,0,380,174,90,40,"TIME")
DRAWBUTTON(18,0,320,270,40,40,"<-")
SETTINGS_DRAW
END SUB
SUB SETTINGS_DRAW
SHOW_FIELD
TEXT 160,38,LEFT$(FMTS(0,LL_FMT)+PAD,6),LT,8,1,C.FOCUS,C.B
TEXT 160,86,LEFT$(FMTS(1,LL_SGN)+PAD,6),LT,8,1,C.FOCUS,C.B
TEXT 160,134,LEFT$(FMTS(2,HD_FMT)+PAD,6),LT,8,1,C.FOCUS,C.B
TEXT 160,182,LEFT$(FMTS(2,VD_FMT)+PAD,6),LT,8,1,C.FOCUS,C.B
TEXT 160,230,LEFT$(FMTS(3,SPD_FMT)+PAD,3),LT,8,1,C.FOCUS,C.B
TEXT 366,38,"LO:"+STR$(B_LOWER,1,1)+"V",LT,8,1,C.FOCUS,C.B
TEXT 366,86,"HI:"+STR$(B_UPPER,1,1)+"V",LT,8,1,C.FOCUS,C.B
TEXT 366,134,"TO:"+STR$(BAT_TO,3)+"s",LT,8,1,C.FOCUS,C.B
IF DST_ON >0 THEN
DRAWBUTTON(15,0,264,222,96,40,"DST +")
ELSE
DRAWBUTTON(15,0,264,222,96,40,"DST -")
ENDIF
IF T_FMT<18 THEN
DRAWBUTTON(17,0,264,174,96,40,"12HR")
ELSE
DRAWBUTTON(17,0,264,174,96,40,"24HR")
ENDIF
IF SND_ON>0 THEN
DRAWBUTTON(19,0,216,222,40,40,"S<")
ELSE
DRAWBUTTON(19,0,216,222,40,40,"S-")
ENDIF
END SUB
SUB TILE_PAGE(PAGE_NUMBER AS INTEGER)
LOCAL INTEGER DONE,I,PAGE,C
PAGE=PAGE_NUMBER
NPG=NEXT_MAIN_PAGE
DONE=0
CLS
PURGE_BUTTONS
DRAWBUTTON(0,0,380,270,90,40,"EXIT")
TEXT 10,0,PAGE_TITLES(PAGE),LT,8,1,C.TITLE,C.B
FOR I=0 TO ITEM_COUNT-1
JUNK=TILE(PAGE_TILES(PAGE,I),1,PG_T_X(PAGE,I),PG_T_Y(PAGE,I),I)
NEXT I
DO WHILE(DONE=0)
FOR I=0 TO ITEM_COUNT-1
JUNK=TILE(PAGE_TILES(PAGE,I),2,PG_T_X(PAGE,I),PG_T_Y(PAGE,I),I)
IDLE(50)
C=CHECKBUTTON(0,ITEM_COUNT)
IF C>-1 THEN
CHECKRELEASE(C)
IF C=0 THEN DONE=1
IF C>0 THEN DONE=TILE(PAGE_TILES(PAGE,C-1),5,PG_T_X(PAGE,C-1),PG_T_Y(PAGE,C-1),I)
ENDIF
NEXT I
LOOP
END SUB
SUB PURGE_BUTTONS
LOCAL INTEGER I
FOR I=0 TO BUTTON_COUNT-1
B_COORD(I,0)=0
B_COORD(I,2)=0
B_COORD(I,3)=0
B_COORD(I,4)=0
BUTTON_TEXT(I)=""
NEXT I
END SUB
SUB MAIN_PAGE
LOCAL INTEGER I,X,Y,C
CLS
TEXT 10,0,"MAIN MENU",LT,8,1,C.TITLE,C.B
PURGE_BUTTONS
FOR I=0 to PG_CNT-1
X=I \ 6
Y=I MOD 6
DRAWBUTTON(I,0,5+160*X,30+48*Y,300,40,LEFT$(PAGE_TITLES(I),PAGE_TITLE_LENGTH-2))
NEXT I
DRAWBUTTON(PG_CNT,0,315,30,150,40,"SETTINGS")
DRAWBUTTON(PG_CNT+1,0,315,78,150,40,"COMPOSE")
DRAWBUTTON(PG_CNT+2,0,315,126,150,40,"POWER("+STR$(PIN(BAT_CTL),1)+")")
DRAWBUTTON(PG_CNT+3,0,315,174,150,40,"POI")
DRAWBUTTON(PG_CNT+4,0,315,222,150,40,"RAW DATA")
DRAWBUTTON(PG_CNT+5,0,315,270,150,40,"SLEEP")
DO
IDLE(100)
C=CHECKBUTTON(0,PG_CNT+5)
IF C>-1 THEN
CHECKRELEASE(C)
IF C<PG_CNT THEN NPG=C:EXIT SUB
IF C=PG_CNT THEN NPG=NEXT_SETTINGS_PAGE:EXIT SUB
IF C=PG_CNT+1 THEN NPG=NEXT_COMPOSE_PAGE:EXIT SUB
IF C=PG_CNT+2 THEN NPG=NEXT_POWER_PAGE:EXIT SUB
IF C=PG_CNT+3 THEN NPG=NEXT_POI_PAGE:EXIT SUB
IF C=PG_CNT+4 THEN NPG=NEXT_RAW_DATA_PAGE:EXIT SUB
IF C=PG_CNT+5 THEN NPG=NEXT_SLEEP_PAGE:EXIT SUB
ENDIF
LOOP
END SUB
SUB COMPOSE_PAGE
LOCAL INTEGER DONE,C,CUR_PAGE,CUR_ITEM,I,X,Y,W,H,TILE_OK
LOCAL INTEGER XT,YT,UT,VT
LOCAL STRING TITLE_Q
DONE=0
CUR_PAGE=0
CUR_ITEM=0
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
DO WHILE (DONE=0)
IDLE(100)
C=CHECKBUTTON(0,6)
IF C>-1 THEN
CHECKRELEASE(C)
IF C=0 THEN DONE=1
IF C=1 THEN
CUR_PAGE=(CUR_PAGE+1) MOD PG_CNT
CUR_ITEM=0
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
IF C=2 THEN
CUR_PAGE=(CUR_PAGE+PG_CNT-1) MOD PG_CNT
CUR_ITEM=0
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
IF C=3 THEN
PAGE_TILES(CUR_PAGE,CUR_ITEM)=0
PG_T_X(CUR_PAGE,CUR_ITEM)=0
PG_T_Y(CUR_PAGE,CUR_ITEM)=0
PG_T_W(CUR_PAGE,CUR_ITEM)=0
PG_T_H(CUR_PAGE,CUR_ITEM)=0
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
IF C=4 THEN
IF PAGE_TILES(CUR_PAGE,CUR_ITEM)<> 0 THEN
MESSAGE_BOX("Clear tile to continue.")
ELSE
ADD_ITEM_TO_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
IF C=5 THEN
CUR_ITEM=(CUR_ITEM+1) MOD ITEM_COUNT
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
IF C=6 THEN
TITLE_Q=KEYBOARD_STRING("Title:")
TITLE_Q=LEFT$(TITLE_Q,TILE_TITLE_LENGTH-1)
IF ACCEPT_STRING(TITLE_Q)>0 THEN PAGE_TITLES(CUR_PAGE)=TITLE_Q:T_TYPE(CUR_PAGE+9)=TITLE_Q
DRAW_COMPOSE_PAGE(CUR_PAGE,CUR_ITEM)
ENDIF
ENDIF
X=TOUCH(X)
Y=TOUCH(Y)
IF X>0 THEN
IF X<362 AND Y>99 THEN
X=((X-1)*4)\3
Y=((Y-76)*4)\3
W=PG_T_W(CUR_PAGE,CUR_ITEM)
H=PG_T_H(CUR_PAGE,CUR_ITEM)
X=X-W\2
Y=Y-H\2
IF X+W >=480 THEN X=479-W
IF X<0 THEN X=0
IF Y+H > 319 THEN Y=319-H
IF Y<30 THEN Y=30
IF VALIDATE_ITEM_POSITION(CUR_PAGE,CUR_ITEM,X,Y,W,H)>0 THEN
SIMPLE_TILE(CUR_PAGE,CUR_ITEM,C.B)
PG_T_X(CUR_PAGE,CUR_ITEM)=X
PG_T_Y(CUR_PAGE,CUR_ITEM)=Y
DRAW_SINGLE_TILE(CUR_PAGE,CUR_ITEM,CUR_ITEM)
IDLE_IGNORE_TOUCH(50)
ENDIF
ENDIF
IDLE_IGNORE_TOUCH(10)
ENDIF
LOOP
END SUB
FUNCTION VALIDATE_ITEM_POSITION(CUR_PAGE AS INTEGER,CUR_ITEM AS INTEGER,X AS INTEGER,Y AS INTEGER,W AS INTEGER,H AS INTEGER) AS INTEGER
LOCAL INTEGER I,XT,YT,UT,VT
VALIDATE_ITEM_POSITION=1
FOR I=0 TO ITEM_COUNT-1
IF I<> CUR_ITEM THEN
XT=PG_T_X(CUR_PAGE,I)
YT=PG_T_Y(CUR_PAGE,I)
UT=XT+PG_T_W(CUR_PAGE,I)
VT=YT+PG_T_H(CUR_PAGE,I)
IF XT >=X AND XT<X+W AND YT >=Y AND YT<Y+H THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF UT >=X AND UT<X+W AND YT >=Y AND YT<Y+H THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF XT >=X AND XT<X+W AND VT >=Y AND VT<Y+H THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF UT >=X AND UT<X+W AND VT >=Y AND VT<Y+H THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF UT+XT >=X+X AND UT+XT<X+W+X+W AND YT+VT >=Y+Y AND YT+VT<Y+H+Y+H THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF X >=XT AND X<UT AND Y >=YT AND Y<VT THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF X+W >=XT AND X+W<UT AND Y >=YT AND Y<VT THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF X >=XT AND X<UT AND Y+H >=YT AND Y+H<VT THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF X+W >=XT AND X+W<UT AND Y+H >=YT AND Y+H<VT THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
IF X+W\2 >=XT AND X+W\2<UT AND Y+H\2 >=YT AND Y+H\2<VT THEN VALIDATE_ITEM_POSITION=0:EXIT FUNCTION
ENDIF
NEXT I
END FUNCTION
SUB ADD_ITEM_TO_PAGE(CUR_PAGE AS INTEGER,CUR_ITEM AS INTEGER)
LOCAL INTEGER I,X,Y,C
CLS
TEXT 10,0,"ADD ITEM",LT,8,1,C.TITLE,C.B
PURGE_BUTTONS
DRAWBUTTON(0,0,380,270,90,40,"EXIT")
FOR I=1 to TILE_TYPE_COUNT-1
X=(I-1) \ 6
Y=(I-1) MOD 6
IF T_TYPE(I)<>"" THEN DRAWBUTTON(I,0,2+120*X,30+48*Y,116,40,LEFT$(T_TYPE(I),13))
NEXT I
DO
IDLE(100)
C=CHECKBUTTON(0,TILE_TYPE_COUNT-1)
IF C>-1 THEN
CHECKRELEASE(C)
IF C=0 THEN EXIT SUB
IF C > 0 THEN
FIT_ITEM_TO_PAGE(CUR_PAGE,CUR_ITEM,C)
EXIT SUB
ENDIF
ENDIF
LOOP
END SUB
SUB FIT_ITEM_TO_PAGE(CUR_PAGE AS INTEGER,CUR_ITEM AS INTEGER,ITEM_TYPE AS INTEGER)
LOCAL INTEGER I,X,Y,W,H
PAGE_TILES(CUR_PAGE,CUR_ITEM)=ITEM_TYPE
PG_T_X(CUR_PAGE,CUR_ITEM)=0
PG_T_Y(CUR_PAGE,CUR_ITEM)=0
LOAD_TILE_VARIABLES
W=PG_T_W(CUR_PAGE,CUR_ITEM)
H=PG_T_H(CUR_PAGE,CUR_ITEM)
DRAWBUTTON(0,0,110,130,260,60,"Placing item...")
FOR I=0 TO ITEM_COUNT-1
X=PG_T_X(CUR_PAGE,I)+PG_T_W(CUR_PAGE,I)+2
Y=PG_T_Y(CUR_PAGE,I)
IF X<0 OR Y<30 OR X+W>479 OR Y+H>319 THEN X=0:Y=0
IF VALIDATE_ITEM_POSITION(CUR_PAGE,CUR_ITEM,X,Y,W,H)>0 THEN
PG_T_X(CUR_PAGE,CUR_ITEM)=X
PG_T_Y(CUR_PAGE,CUR_ITEM)=Y
EXIT SUB
ENDIF
NEXT I
FOR I=0 TO ITEM_COUNT-1
X=PG_T_X(CUR_PAGE,I)
Y=PG_T_Y(CUR_PAGE,I)+PG_T_H(CUR_PAGE,I)+2
IF X<0 OR Y<30 OR X+W>479 OR Y+H>319 THEN X=0:Y=0
IF VALIDATE_ITEM_POSITION(CUR_PAGE,CUR_ITEM,X,Y,W,H)>0 THEN
PG_T_X(CUR_PAGE,CUR_ITEM)=X
PG_T_Y(CUR_PAGE,CUR_ITEM)=Y
EXIT SUB
ENDIF
NEXT I
X=0
Y=30
DO WHILE Y<318-H
IF VALIDATE_ITEM_POSITION(CUR_PAGE,CUR_ITEM,X,Y,W,H)>0 THEN
PG_T_X(CUR_PAGE,CUR_ITEM)=X
PG_T_Y(CUR_PAGE,CUR_ITEM)=Y
EXIT SUB
ENDIF
Y=Y+10
LOOP
I=100
DO WHILE I > 0
X=RND(1)*(478-W)
Y=(RND(1)*(288-W))+30
IF X<0 OR Y<30 OR X+W>479 OR Y+H>319 THEN X=0:Y=0
IF VALIDATE_ITEM_POSITION(CUR_PAGE,CUR_ITEM,X,Y,W,H)>0 THEN
PG_T_X(CUR_PAGE,CUR_ITEM)=X
PG_T_Y(CUR_PAGE,CUR_ITEM)=Y
EXIT SUB
ENDIF
I=I-1
LOOP
MESSAGE_BOX("No room on page for item.")
PAGE_TILES(CUR_PAGE,CUR_ITEM)=0
PG_T_X(CUR_PAGE,CUR_ITEM)=0
PG_T_Y(CUR_PAGE,CUR_ITEM)=0
PG_T_W(CUR_PAGE,CUR_ITEM)=0
PG_T_H(CUR_PAGE,CUR_ITEM)=0
END SUB
SUB DRAW_COMPOSE_PAGE(CUR_PAGE AS INTEGER,CUR_ITEM AS INTEGER)
CLS
TEXT 10,0,"PAGE "+STR$(CUR_PAGE+1)+" ITEM "+STR$(CUR_ITEM+1),LT,8,1,C.TITLE,C.B
TEXT 120,38,PAGE_TITLES(CUR_PAGE),LT,8,1,C.TITLE,C.B
DRAWBUTTON(0,0,380,270,90,40,"EXIT")
DRAWBUTTON(1,0,380,30,90,40,"NEXT")
DRAWBUTTON(2,0,380,78,90,40,"PREV")
DRAWBUTTON(3,0,380,126,90,40,"CLEAR")
DRAWBUTTON(4,0,380,174,90,40,"ADD")
DRAWBUTTON(5,0,380,222,90,40,"SEL<>")
DRAWBUTTON(6,0,10,30,90,40,"TITLE")
BOX 0,75,362,242,1,C.TITLE,-1
DRAW_COMPOSE_TILES(CUR_PAGE,CUR_ITEM)
END SUB
SUB DRAW_COMPOSE_TILES(CUR_PAGE AS INTEGER,CUR_ITEM AS INTEGER)
LOCAL INTEGER I
BOX 0,75,362,242,1,C.TITLE,C.B
BOX 0,75,362,23,1,C.TITLE,C.TITLE
FOR I=0 TO ITEM_COUNT-1
DRAW_SINGLE_TILE(CUR_PAGE,I,CUR_ITEM)
NEXT I
END SUB
SUB DRAW_SINGLE_TILE(CUR_PAGE AS INTEGER,ITEM AS INTEGER,CUR_ITEM AS INTEGER)
IF ITEM=CUR_ITEM THEN
SIMPLE_TILE(CUR_PAGE,ITEM,C.FOCUS)
ELSE
SIMPLE_TILE(CUR_PAGE,ITEM,C.TITLE)
ENDIF
END SUB
SUB SIMPLE_TILE(CUR_PAGE AS INTEGER,ITEM AS INTEGER,C AS INTEGER)
LOCAL INTEGER X,Y,W,H,TT,FNT
FNT=8
TT=PAGE_TILES(CUR_PAGE,ITEM)
IF TT=0 THEN EXIT SUB
X=(PG_T_X(CUR_PAGE,ITEM)*3)\4
Y=(PG_T_Y(CUR_PAGE,ITEM)*3)\4
W=(PG_T_W(CUR_PAGE,ITEM)*3)\4
H=(PG_T_H(CUR_PAGE,ITEM)*3)\4
IF W<LEN(T_TYPE(TT))*16+2 THEN FNT=1
IF H<26 THEN FNT=1
BOX 1+X,76+Y,W,H,1,C,-1
TEXT 1+X+W\2,76+Y+H\2,T_TYPE(TT),CM,FNT,1,C,C.B
END SUB
SUB RAW_DATA_PAGE
LOCAL INTEGER DONE,C
LOCAL STRING TMP
DONE=0
DRAW_RAW
DO WHILE (DONE=0)
TEXT 10,70,"SUPPLY:"+STR$(SUPPLY_VOLTAGE,2,2)+"V",LT,8,1,C.F,C.B
TEXT 10,100,"ALT:"+STR$(ALT,5,1)+"m     ",LT,8,1,C.F,C.B
TEXT 10,130,"SAT COUNT:"+STR$(SAT_COUNT)+PAD,LT,8,1,C.F,C.B
TEXT 280,130,"MODE/FIX:"+STR$(GPS_OK)+PAD,LT,8,1,C.F,C.B
TEXT 10,160,"LAT:"+STR$(LATITUDE)+PAD,LT,8,1,C.F,C.B
TEXT 280,160,"LON:"+STR$(LONGITUDE)+PAD,LT,8,1,C.F,C.B
TEXT 10,190,"SPEED:"+STR$(SPEED,4,1)+"m/s     ",LT,8,1,C.F,C.B
TEXT 280,190,"TRACK:"+STR$(TRACK,3,1)+"`     ",LT,8,1,C.F,C.B
TEXT 10,220,"TIME:"+GPS_TIME+PAD,LT,8,1,C.F,C.B
TEXT 280,220,"DATE:"+GPS_DATE+PAD,LT,8,1,C.F,C.B
TEXT 10,250,"LDR:"+STR$(PIN(LDR_PIN),1,2)+"V ",LT,8,1,C.F,C.B
TEXT 10,280,"BACKLIGHT:"+STR$(BL_ACT,3,0)+"% ",LT,8,1,C.F,C.B
TEXT 280,70,"VOL:"+STR$(VOL_ACT,3,0)+"% ",LT,8,1,C.F,C.B
IDLE(300)
C=CHECKBUTTON(0,0)
IF C>-1 THEN
CHECKRELEASE(C)
IF C=0 THEN DONE=1
ENDIF
ENDIF
LOOP
END SUB
SUB DRAW_RAW
CLS
TEXT 10,0,"RAW DATA",LT,8,1,C.TITLE,C.B
DRAWBUTTON(0,0,380,260,90,40,"EXIT")
END SUB
SUB LOAD_TILE_VARIABLES
LOCAL INTEGER I,J
FOR J=0 to PG_CNT-1
FOR I=0 TO ITEM_COUNT-1
PG_T_W(J,I)=TILE(PAGE_TILES(J,I),TILE_W,0,0)
PG_T_H(J,I)=TILE(PAGE_TILES(J,I),TILE_H,0,0)
NEXT I
next J
END SUB
FUNCTION TILE(N AS INTEGER,F AS INTEGER,X AS INTEGER,Y AS INTEGER,P AS INTEGER) AS INTEGER
IF N=1 THEN TILE=TILE_COMPASS(F,X,Y):EXIT FUNCTION
IF N=2 THEN TILE=TILE_COMPASS2(F,X,Y):EXIT FUNCTION
IF N=3 THEN TILE=TILE_SPEED(F,X,Y):EXIT FUNCTION
IF N=4 THEN TILE=TILE_LAT(F,X,Y):EXIT FUNCTION
IF N=5 THEN TILE=TILE_LON(F,X,Y):EXIT FUNCTION
IF N=6 THEN TILE=TILE_ALT(F,X,Y):EXIT FUNCTION
IF N=7 THEN TILE=TILE_BEARING(F,X,Y):EXIT FUNCTION
IF N=8 THEN TILE=TILE_SPEED_BIG(F,X,Y):EXIT FUNCTION
IF (N >=9 AND N<=12) OR (N>=17 AND N<=19) THEN
TILE=TILE_PAGE_BUTTON(N,F,X,Y,P)
EXIT FUNCTION
ENDIF
IF N=13 THEN TILE=TILE_POI_COMPASS(F,X,Y):EXIT FUNCTION
IF N=14 THEN TILE=TILE_HPOI(F,X,Y):EXIT FUNCTION
IF N=15 THEN TILE=TILE_VPOI(F,X,Y):EXIT FUNCTION
IF N=16 THEN TILE=TILE_SZW(F,X,Y):EXIT FUNCTION
IF N=20 THEN TILE=TILE_VOL(F,X,Y):EXIT FUNCTION
IF N=21 THEN TILE=TILE_PN(F,X,Y):EXIT FUNCTION
IF N=22 THEN TILE=TILE_PHDG(F,X,Y):EXIT FUNCTION
IF N=23 THEN TILE=TILE_AVSPD(F,X,Y,P):EXIT FUNCTION
END FUNCTION
FUNCTION TILE_AVSPD(F AS INTEGER,X AS INTEGER,Y AS INTEGER,P AS INTEGER) AS INTEGER
LOCAL INTEGER S
IF F=TILE_W THEN TILE_AVSPD=278:EXIT FUNCTION
IF F=TILE_H THEN TILE_AVSPD=98:EXIT FUNCTION
IF F=1 OR F=2 THEN
IF TIMER-TILE_AVSPD_INIT_T > 100  THEN
S=(TIMER-TILE_AVSPD_INIT_T)\1000
DRAWBUTTON(P+1,0,X+4,Y+48,270,40,"AVE:"+STR$((S\3600) MOD 60,4,0)+":"+STR$((S\60) MOD 60,2,0,"0")+":"+STR$(S MOD 60,2,0,"0"))
S=TIMER
TEXT X+1,Y,STR$(TILE_AVSPD_TOTAL*U_MULT(SPD_FMT)/(S-TILE_AVSPD_INIT_T),3,1)+FMTS(3,SPD_FMT),LT,8,2,C.FOCUS,C.B
ENDIF
ENDIF
IF F=TILE_PRESS THEN
TILE_AVSPD=0
TILE_AVSPD_TOTAL=0
S=TIMER
TILE_AVSPD_INIT_T=S
TILE_AVSPD_LAST_T=S
ENDIF
END FUNCTION
FUNCTION TILE_PHDG(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL FLOAT DTRACK
LOCAL INTEGER C
DTRACK=((TRACK - CURR_POI_H +540) MOD 360)-180
IF F=TILE_W THEN TILE_PHDG=198:EXIT FUNCTION
IF F=TILE_H THEN TILE_PHDG=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
IF DTRACK<0 THEN C=C.FOCUS ELSE C=C.TITLE
TEXT X+2,Y,"<",LT,8,2,C,C.B
TEXT X+34,Y,STR$(ABS(DTRACK),3)+"`",LT,8,2,C.FOCUS,C.B
IF DTRACK > 0 THEN C=C.FOCUS ELSE C=C.TITLE
TEXT X+162,Y,">",LT,8,2,C,C.B
ENDIF
END FUNCTION
FUNCTION TILE_PN(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
TILE_PN=F
IF F=TILE_W THEN TILE_PN=238:EXIT FUNCTION
IF F=TILE_H THEN TILE_PN=28:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X,Y+2,LEFT$(POI_NAME(CURR_POI)+PAD,15),LT,8,1,C.TITLE,C.B
ENDIF
END FUNCTION
FUNCTION TILE_VOL(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL INTEGER S,C
C=C.OK
IF F=TILE_W THEN TILE_VOL=260:EXIT FUNCTION
IF F=TILE_H THEN TILE_VOL=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
FOR S=0 TO 248 STEP 8
IF S>100 THEN C=C.WARN
IF S>200 THEN C=C.ERROR
IF S>VOL_ACT THEN C=C.TITLE
BOX X+S+1,Y+1,6,46,1,C,C
NEXT S
ENDIF
END FUNCTION
FUNCTION TILE_SZW(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL INTEGER S,C
S=(VAL(MID$(TIME$,1,2))*3600+VAL(MID$(TIME$,4,2))*60+VAL(MID$(TIME$,7,2))+TZONE*60+DST_ON*3600+172800) MOD 86400
IF F=TILE_W THEN TILE_SZW=158:EXIT FUNCTION
IF F=TILE_H THEN TILE_SZW=28:EXIT FUNCTION
IF F=1 OR F=2 THEN
IF (S > 8*3600 AND S<9.5*3600) OR (S>14.5*3600 AND S<16*3600) THEN
IF (TIMER\1000) MOD 2=0 THEN C=C.FOCUS ELSE C=C.B
PLAY_LPC(PEEK(CFUNADDR LPC_sp4_WARNING))
ELSE
C=C.B
ENDIF
TEXT X+80,Y+15,"  SCHOOL  ",CM,8,1,C.B,C
ENDIF
END FUNCTION
FUNCTION TILE_HPOI(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL STRING D
IF F=TILE_W THEN TILE_HPOI=158:EXIT FUNCTION
IF F=TILE_H THEN TILE_HPOI=28:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X,Y+2,LEFT$(GET_DIST_STRING(CURR_POI_D),10),LT,8,1,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION TILE_VPOI(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL STRING D
IF F=TILE_W THEN TILE_VPOI=128:EXIT FUNCTION
IF F=TILE_H THEN TILE_VPOI=28:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X,Y+2,LEFT$(GET_ALT_STRING(POI_H(CURR_POI)-ALT),8),LT,8,1,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION TILE_POI_COMPASS(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL FLOAT DTRACK
DTRACK=TRACK - CURR_POI_H
IF F=TILE_W THEN TILE_POI_COMPASS=198:EXIT FUNCTION
IF F=TILE_H THEN TILE_POI_COMPASS=178:EXIT FUNCTION
LOCAL FLOAT S,C,D
LOCAL INTEGER I
IF F=1 THEN
TILE_CPLT=1080
CIRCLE X+100,Y+100,75,8,1,C.F,C.B
TEXT X+12,Y+100,"P",CM,8,1,C.F,C.B
TEXT X+188,Y+100,"S",CM,8,1,C.F,C.B
CIRCLE X+100,Y+100,10,1,1,C.FOCUS,C.FOCUS
ENDIF
IF F=1 OR F=2 THEN
IF ABS(TILE_CPLT-DTRACK)<1 THEN EXIT FUNCTION
D=TILE_CPLT*0.017453292
S=SIN(D)
C=COS(D)
FOR I=-8 TO 8
LINE X+100+C*I,Y+100+S*I,X+100+S*68,Y+100-C*68,1,C.B
NEXT I
TILE_CPLT=DTRACK
D=DTRACK*0.017453292
S=SIN(D)
C=COS(D)
FOR I=-8 TO 8
LINE X+100+C*I,Y+100+S*I,X+100+S*68,Y+100-C*68,1,C.FOCUS
NEXT I
CIRCLE X+100,Y+100,10,1,1,C.FOCUS,C.FOCUS
TEXT X+100,Y+12,STR$(((DTRACK+540)mod 360)-180,4,0)+"`",CM,8,1,C.F,C.B
ENDIF
END FUNCTION
FUNCTION TILE_PAGE_BUTTON(N AS INTEGER,F AS INTEGER,X AS INTEGER,Y AS INTEGER,P AS INTEGER) AS INTEGER
LOCAL STRING D
IF N<9+PG_CNT THEN D=PAGE_TITLES(N-9)
IF N=17 THEN D="POI"
IF N=18 THEN D="SETTINGS"
IF N=19 THEN D="SLEEP"
IF F=TILE_W THEN TILE_PAGE_BUTTON=156:EXIT FUNCTION
IF F=TILE_H THEN TILE_PAGE_BUTTON=48:EXIT FUNCTION
IF F=1  THEN
DRAWBUTTON(P+1,0,X+1,Y+4,150,40,D)
ENDIF
IF F=TILE_PRESS THEN
NPG=N-9
IF N=17 then NPG=NEXT_POI_PAGE
IF N=18 then NPG=NEXT_SETTINGS_PAGE
IF N=19 then NPG=NEXT_SLEEP_PAGE
TILE_PAGE_BUTTON=1
ENDIF
END FUNCTION
FUNCTION TILE_BEARING(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
LOCAL STRING D
IF F=TILE_W THEN TILE_BEARING=148:EXIT FUNCTION
IF F=TILE_H THEN TILE_BEARING=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X+10,Y,LEFT$(STR$(TRACK,3,0)+"`   ",4),LT,8,2,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION TILE_ALT(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_ALT=258:EXIT FUNCTION
IF F=TILE_H THEN TILE_ALT=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X+8,Y,LEFT$(GET_ALT_STRING(ALT)+PAD,8),LT,8,2,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION GET_DIST_STRING(DIST AS FLOAT) AS STRING
LOCAL INTEGER A,B
A=5:B=2
if HD_FMT=DIST_METRE OR HD_FMT=DIST_F THEN A=8:B=0
GET_DIST_STRING=STR$(DIST*D_MULT(HD_FMT),A,B)+FMTS(4,HD_FMT)
END FUNCTION
FUNCTION GET_ALT_STRING(DIST AS FLOAT) AS STRING
LOCAL INTEGER A,B
A=2:B=3
if HD_FMT=DIST_METRE OR HD_FMT=DIST_F THEN A=5:B=0
if HD_FMT=DIST_FL THEN A=3:B=2
GET_ALT_STRING=STR$(DIST*D_MULT(HD_FMT),A,B)+FMTS(4,VD_FMT)
END FUNCTION
FUNCTION TILE_LAT(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_LAT=398:EXIT FUNCTION
IF F=TILE_H THEN TILE_LAT=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X+8,Y,LEFT$(GET_LAT_STRING(LATITUDE)+PAD,12),LT,8,2,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION TILE_LON(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_LON=398:EXIT FUNCTION
IF F=TILE_H THEN TILE_LON=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
TEXT X+8,Y,LEFT$(GET_LON_STRING(LONGITUDE)+PAD,12),LT,8,2,C.FOCUS,C.B
ENDIF
END FUNCTION
FUNCTION GET_LAT_STRING(S AS FLOAT) AS STRING
LOCAL STRING D
IF LL_FMT=LL_DMS_FORMAT THEN
D=STR$(INT(ABS(S)),3,0)+"`"+STR$((INT(ABS(S)*60) MOD 60),2,0)+"'"+STR$((INT(ABS(S)*3600) MOD 60),2,0)+chR$(34)
ELSE IF LL_FMT=LL_DD_FORMAT THEN
D=STR$(ABS(S),3,6)+"`"
ELSE IF LL_FMT=LL_GPS_FORMAT THEN
D=STR$(INT(ABS(S)),3,0)+STR$((INT(ABS(S)*60) MOD 60),2,0)+"."+STR$((INT(ABS(S)*3600) MOD 60),4,0)
ENDIF
IF LL_SGN=LL_NEGSIGN THEN
IF S<0 THEN D="-"+D ELSE D=" "+D
ELSE IF LL_SGN=LL_SIGN THEN
IF S<0 THEN D="-"+D ELSE D="+"+D
ELSE IF LL_SGN=LL_NSEW THEN
IF S<0 THEN D=D+"S" ELSE D=D+"N"
ENDIF
GET_LAT_STRING=D
END FUNCTION
FUNCTION GET_LON_STRING(S AS FLOAT) AS STRING
LOCAL STRING D
IF LL_FMT=LL_DMS_FORMAT THEN
D=STR$(INT(ABS(S)),3,0)+"`"+STR$((INT(ABS(S)*60) MOD 60),2,0)+"'"+STR$((INT(ABS(S)*3600) MOD 60),2,0)+chR$(34)
ELSE IF LL_FMT=LL_DD_FORMAT THEN
D=STR$(ABS(S),3,6)+"`"
ELSE IF LL_FMT=LL_GPS_FORMAT THEN
D=STR$(INT(ABS(S)),3,0)+STR$((INT(ABS(S)*60) MOD 60),2,0)+"."+STR$((INT(ABS(S)*3600) MOD 60),4,0)
ENDIF
IF LL_SGN=LL_NEGSIGN THEN
IF S<0 THEN D="-"+D ELSE D=" "+D
ELSE IF LL_SGN=LL_SIGN THEN
IF S<0 THEN D="-"+D ELSE D="+"+D
ELSE IF LL_SGN=LL_NSEW THEN
IF S<0 THEN D=D+"W" ELSE D=D+"E"
ENDIF
GET_LON_STRING=D
END FUNCTION
FUNCTION TILE_COMPASS(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_COMPASS=198:EXIT FUNCTION
IF F=TILE_H THEN TILE_COMPASS=198:EXIT FUNCTION
LOCAL FLOAT S,C,D
LOCAL INTEGER I
IF F=1 THEN
TILE_CLT=1080
CIRCLE X+100,Y+100,75,8,1,C.F,C.B
TEXT X+100,Y+12,"N",CM,8,1,C.F,C.B
TEXT X+100,Y+188,"S",CM,8,1,C.F,C.B
TEXT X+12,Y+100,"W",CM,8,1,C.F,C.B
TEXT X+188,Y+100,"E",CM,8,1,C.F,C.B
CIRCLE X+100,Y+100,10,1,1,C.FOCUS,C.FOCUS
ENDIF
IF F=1 OR F=2 THEN
IF ABS(TILE_CLT-TRACK)<1 THEN EXIT FUNCTION
D=TILE_CLT*0.017453292
S=SIN(D)
C=COS(D)
FOR I=-8 TO 8
LINE X+100+C*I,Y+100+S*I,X+100+S*68,Y+100-C*68,1,C.B
NEXT I
TILE_CLT=TRACK
D=TRACK*0.017453292
S=SIN(D)
C=COS(D)
FOR I=-8 TO 8
LINE X+100+C*I,Y+100+S*I,X+100+S*68,Y+100-C*68,1,C.FOCUS
NEXT I
CIRCLE X+100,Y+100,10,1,1,C.FOCUS,C.FOCUS
ENDIF
END FUNCTION
FUNCTION TILE_COMPASS2(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_COMPASS2=198:EXIT FUNCTION
IF F=TILE_H THEN TILE_COMPASS2=198:EXIT FUNCTION
LOCAL FLOAT S,C,D
LOCAL INTEGER I
IF F=1 THEN
TILE_C2LT=1080
CIRCLE X+100,Y+100,75,8,1,C.F,C.B
CIRCLE X+100,Y+100,10,1,1,C.FOCUS,C.FOCUS
S=0
C=1
LINE X+100,Y+100,X+100+S*70,Y+100-C*70,1,C.FOCUS
FOR I=-8 TO 8
LINE X+100-C*I,Y+100+S*I,X+100+S*70,Y+100-C*70,1,C.FOCUS
NEXT I
ENDIF
IF F=1 OR F=2 THEN
TEXT X+100,Y+130,STR$(TRACK,3,0)+"`",CM,8,1,C.FOCUS,C.B
IF ABS(TILE_C2LT-TRACK)<1 THEN EXIT FUNCTION
D=TILE_C2LT*0.017453292
S=SIN(D)
C=COS(D)
TEXT X+100-S*88,Y+100-C*88,"N",CM,8,1,C.B,C.B
TEXT X+100+S*88,Y+100+C*88,"S",CM,8,1,C.B,C.B
TEXT X+100-C*88,Y+100+S*88,"W",CM,8,1,C.B,C.B
TEXT X+100+C*88,Y+100-S*88,"E",CM,8,1,C.B,C.B
TILE_C2LT=TRACK
D=TRACK*0.017453292
S=SIN(D)
C=COS(D)
TEXT X+100-S*88,Y+100-C*88,"N",CM,8,1,C.FOCUS,C.B
TEXT X+100+S*88,Y+100+C*88,"S",CM,8,1,C.FOCUS,C.B
TEXT X+100-C*88,Y+100+S*88,"W",CM,8,1,C.FOCUS,C.B
TEXT X+100+C*88,Y+100-S*88,"E",CM,8,1,C.FOCUS,C.B
CIRCLE X+100,Y+100,75,8,1,C.F,-1
ENDIF
END FUNCTION
FUNCTION TILE_SPEED(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_SPEED=238:EXIT FUNCTION
IF F=TILE_H THEN TILE_SPEED=48:EXIT FUNCTION
IF F=1 OR F=2 THEN
LOCAL FLOAT SPD
SPD=SPEED*U_MULT(SPD_FMT)
if SPD<99.9 THEN
TEXT X+8,Y+1,STR$(SPD,2,1)+FMTS(3,SPD_FMT),LT,8,2,C.FOCUS,C.B
ELSE
TEXT X+8,Y+1,STR$(SPD,4,0)+FMTS(3,SPD_FMT),LT,8,2,C.FOCUS,C.B
ENDIF
ENDIF
END FUNCTION
FUNCTION TILE_SPEED_BIG(F AS INTEGER,X AS INTEGER,Y AS INTEGER) AS INTEGER
IF F=TILE_W THEN TILE_SPEED_BIG=476:EXIT FUNCTION
IF F=TILE_H THEN TILE_SPEED_BIG=198:EXIT FUNCTION
IF F=1 OR F=2 THEN
LOCAL FLOAT SPD
SPD=SPEED*U_MULT(SPD_FMT)
TEXT X,Y+3,STR$(SPD,3,0),LT,8,8,C.FOCUS,C.B
TEXT X+380,Y+111,FMTS(3,SPD_FMT),LT,8,2,C.FOCUS,C.B
ENDIF
END FUNCTION
SUB IDLE(MS AS INTEGER)
LOCAL INTEGER STARTT,DONE
STARTT=TIMER
DONE=0
DO WHILE (DONE=0)
IDLE_COMMON
IF (TIMER-STARTT)>MS THEN DONE=1
IF TOUCH(X)>-1 THEN DONE=1
LOOP
GET_BATTERY
BATTERY_STATE_CHECK
IF TIMER - LAST_GPS_TIME > GPS_TIMEOUT THEN GPS_OK=0
END SUB
SUB IDLE_IGNORE_TOUCH(MS AS INTEGER)
LOCAL INTEGER STARTT,DONE
STARTT=TIMER
DONE=0
DO WHILE (DONE=0)
IDLE_COMMON
IF (TIMER-STARTT)>MS THEN DONE=1
LOOP
GET_BATTERY
BATTERY_STATE_CHECK
IF TIMER - LAST_GPS_TIME > GPS_TIMEOUT THEN GPS_OK=0
END SUB
SUB IDLE_COMMON
LOCAL FLOAT T
IF LEN(GPS_DATA)<250 THEN GPS_DATA=GPS_DATA+Input$(254-LEN(GPS_DATA),#1)
JUNK=COMBINED(GPS_PARSE)
IF JUNK>0 THEN GPS_UPDATE(JUNK)
T=PIN(LDR_PIN)/3-0.15
BL_TGT=BL_HI*T+BL_LO*(1-T)
IF BL_TGT<BL_LO THEN BL_TGT=BL_LO
IF BL_TGT>BL_HI THEN BL_TGT=BL_HI
DO WHILE BL_TM<TIMER
IF BL_TGT<BL_ACT THEN BL_ACT=BL_ACT-1
IF BL_TGT>BL_ACT THEN BL_ACT=BL_ACT+1
BL_TM=BL_TM+BL_STEP
LOOP
PWM 2,50000,BL_ACT
IF SP_HI-SP_LO<1 THEN
T=1
ELSE
T=(SPEED-SP_LO)/(SP_HI-SP_LO)
ENDIF
VOL_TGT=VOL_HI*T + VOL_LO*(1-T)
IF VOL_TGT<VOL_LO THEN VOL_TGT=VOL_LO
IF VOL_TGT > VOL_HI THEN VOL_TGT=VOL_HI
DO WHILE VOL_TM<TIMER
IF VOL_TGT<VOL_ACT THEN VOL_ACT=VOL_ACT-1
IF VOL_TGT>VOL_ACT THEN VOL_ACT=VOL_ACT+1
VOL_TM=VOL_TM+BL_STEP
LOOP
SET_VOLUME(VOL_ACT)
END SUB
SUB BATTERY_STATE_CHECK
IF (TIMER-LAST_BATTERY_UPDATE)<500 THEN EXIT SUB
LAST_BATTERY_UPDATE=TIMER
LOCAL INTEGER C
IF SUPPLY_VOLTAGE > B_UPPER THEN
BATTERY_OK_TIME=TIMER
TEXT 416,0,"5",LT,7,1,C.OK,C.B
TEXT 432,0,"USB",LT,8,1,C.OK,C.B
ELSE IF SUPPLY_VOLTAGE > B_LOWER THEN
IF (B_UPPER-B_LOWER)<0.1 THEN
C=0
ELSE
C=(SUPPLY_VOLTAGE-B_LOWER)*100/(B_UPPER-B_LOWER)
IF C<0 THEN C=0
IF C>99 THEN C=99
ENDIF
TEXT 416,0,CHR$(C\20+48),LT,7,1,C.WARN,C.B
TEXT 432,0,STR$(C,2,0)+"%",LT,8,1,C.WARN,C.B
BATTERY_OK_TIME=TIMER
ELSE
C=BAT_TO-((TIMER-BATTERY_OK_TIME)\1000)
IF C<0 THEN PIN(BAT_CTL)=0:C=0
IF C>99 THEN C=99
TEXT 416,0,"0",LT,7,1,C.ERROR,C.B
TEXT 432,0,STR$(C,2,0)+"s",LT,8,1,C.ERROR,C.B
ENDIF
IF GPS_OK>0 THEN
TEXT 392,0,"G",LT,8,1,C.OK,C.B
ELSE
TEXT 392,0,"G",LT,8,1,C.ERROR,C.B
ENDIF
TEXT 256,0,DISP_TIME(),LT,8,1,C.F,C.B
END SUB
FUNCTION DISP_TIME() AS STRING
LOCAL INTEGER S
S=(VAL(MID$(TIME$,1,2))*3600+VAL(MID$(TIME$,4,2))*60+VAL(MID$(TIME$,7,2))+TZONE*60+DST_ON*3600+172800) MOD 86400
IF T_FMT<18 THEN
DISP_TIME=STR$(((S\3600+11) MOD 12)+1,2,0)+":"+STR$(((S\60) MOD 60),2,0,"0")
IF S<43200 THEN DISP_TIME=DISP_TIME+"AM " ELSE DISP_TIME=DISP_TIME+"PM "
ELSE
DISP_TIME=STR$(((S\3600) MOD 24),2,0)+":"+STR$(((S\60) MOD 60),2,0,"0")+":"+STR$(((S) MOD 60),2,0,"0")
ENDIF
END FUNCTION
SUB GPS_UPDATE(PARSER AS INTEGER)
LOCAL INTEGER S
IF PARSER=GPS_PARSER0 THEN
IF GPRMC_PARSE(3)="A" THEN
GPS_OK=1
LAST_GPS_TIME=TIMER
ALT=VAL(GPGGA_PARSE(10))
SET_LATITUDE
SET_LONGITUDE
SPEED=VAL(GPRMC_PARSE(8))*0.514444444
IF(SPEED>1) THEN TRACK=VAL(GPRMC_PARSE(9))
GPS_TIME=GPRMC_PARSE(2)
GPS_DATE=GPRMC_PARSE(10)
S=TIMER
TILE_AVSPD_TOTAL=TILE_AVSPD_TOTAL+(S-TILE_AVSPD_LAST_T)*SPEED
TILE_AVSPD_LAST_T=S
ELSE
GPS_OK=0
ENDIF
ENDIF
IF PARSER=GPS_PARSER2 THEN
SAT_COUNT=val(GPGSV_PARSE(4))
ENDIF
CURR_POI_D=GLOBE_D(POI_LAT(CURR_POI),POI_LON(CURR_POI))
CURR_POI_H=GLOBE_H(POI_LAT(CURR_POI),POI_LON(CURR_POI))
END SUB
SUB SET_LATITUDE
LOCAL FLOAT D,M,S
D=COMBINED(GPS_GET_DEG,PEEK(VARADDR GPRMC_PARSE(4)))
IF D<0 THEN GPS_OK=0:EXIT SUB
M=COMBINED(GPS_GET_MIN,PEEK(VARADDR GPRMC_PARSE(4)))
IF M<0 THEN GPS_OK=0:EXIT SUB
S=COMBINED(GPS_GET_SEC,PEEK(VARADDR GPRMC_PARSE(4)))
IF S<0 THEN GPS_OK=0:EXIT SUB
LATITUDE=D+M/60+S/6000000
IF GPRMC_PARSE(5)="S" THEN LATITUDE=-LATITUDE
END SUB
SUB SET_LONGITUDE
LOCAL FLOAT D,M,S
D=COMBINED(GPS_GET_DEG,PEEK(VARADDR GPRMC_PARSE(6)))
IF D<0 THEN GPS_OK=0:EXIT SUB
M=COMBINED(GPS_GET_MIN,PEEK(VARADDR GPRMC_PARSE(6)))
IF M<0 THEN GPS_OK=0:EXIT SUB
S=COMBINED(GPS_GET_SEC,PEEK(VARADDR GPRMC_PARSE(6)))
IF S<0 THEN GPS_OK=0:EXIT SUB
LONGITUDE=D+M/60+S/6000000
IF GPRMC_PARSE(7)="W" THEN LONGITUDE=-LONGITUDE
END SUB
FUNCTION KEYBOARD_NUMBER(PROMPT AS STRING) AS STRING
KEYBOARD_NUMBER=""
LOCAL INTEGER DONE,KEY_FETCH,LAST_KEY,X,Y,N,CURSOR_POS
DONE=0
LAST_KEY=-1
CLS
TEXT 2,0,PROMPT,LT,8,2,C.WARN,C.B
BOX 2,48,476,60,3,C.F
FOR Y=0 TO 17
DRAW_NUMBER_KEY(Y,0)
NEXT Y
DO WHILE (DONE=0)
X=TOUCH(X)
Y=TOUCH(Y)
KEY_FETCH=X\80+((Y-120)\66)*6
IF (KEY_FETCH<0) OR (KEY_FETCH>17) THEN KEY_FETCH=-1
IF (KEY_FETCH > -1) AND (LAST_KEY=-1) THEN
PLAY_PIP
DRAW_NUMBER_KEY(KEY_FETCH,1)
IF MID$(KEYS_NUMBER,KEY_FETCH+1,1)="<" THEN
IF LEN(KEYBOARD_NUMBER)>0 THEN
KEYBOARD_NUMBER=LEFT$(KEYBOARD_NUMBER,LEN(KEYBOARD_NUMBER)-1)
ENDIF
ELSE IF KEY_FETCH=17 THEN
DONE=1
ELSE
KEYBOARD_NUMBER=KEYBOARD_NUMBER+MID$(KEYS_NUMBER,KEY_FETCH+1,1)
ENDIF
IF LEN(KEYBOARD_NUMBER)>14 THEN KEYBOARD_NUMBER=lEFT$(KEYBOARD_NUMBER,14)
TEXT 8,54,LEFT$(KEYBOARD_NUMBER+PAD,14),LT,8,2,C.F,C.B
LINE 456,54,456,100,2,C.B
ENDIF
IF (KEY_FETCH<> LAST_KEY) AND (LAST_KEY<> -1) THEN
DRAW_NUMBER_KEY(LAST_KEY,0)
LAST_KEY=KEY_FETCH
END IF
LAST_KEY=KEY_FETCH
CURSOR_POS=len(KEYBOARD_NUMBER)
IF ((TIMER \ 500) MOD 2) > 0 THEN
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.F
ELSE
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.B
ENDIF
IDLE(20)
IF DONE > 0 THEN
DO WHILE TOUCH(X)>-1
IDLE(50)
LOOP
DRAW_NUMBER_KEY(14,0)
IDLE(50)
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.B
ENDIF
LOOP
END FUNCTION
SUB DRAW_NUMBER_KEY(N AS INTEGER,PRESSED AS INTEGER)
LOCAL INTEGER X,Y
LOCAL STRING S
IF N<0 OR N>17 THEN EXIT SUB
S=MID$(KEYS_NUMBER,N+1,1)
IF N=17 THEN S="OK"
IF S="<" THEN S="<-"
IF S=" " THEN EXIT SUB
X=N MOD 6
Y=N \ 6
LOCAL INTEGER F,B
IF PRESSED > 0 THEN
F=C.B
B=C.F
ELSE
F=C.F
B=C.B
ENDIF
BOX X*80,Y*66+120,78,64,1,F,B
TEXT X*80+40,Y*66+153,S,CM,8,2,F,B
END SUB
FUNCTION KEYBOARD_STRING(PROMPT AS STRING) AS STRING
KEYBOARD_STRING=""
LOCAL STRING LEFT_PART
LOCAL INTEGER SHIFT_STATE,DONE,KEY_FETCH,LAST_KEY,CURSOR_POS,LEFT_TRIM
LEFT_PART=""
SHIFT_STATE=0
DONE=0
LAST_KEY=-1
CURSOR_POS=0
LEFT_TRIM=0
CLS
TEXT 2,0,PROMPT,LT,8,2,C.WARN,C.B
DRAW_KEYS(0)
BOX 2,48,476,60,3,C.F
DO WHILE (DONE=0)
KEY_FETCH=GET_KEY(SHIFT_STATE)
IF (KEY_FETCH > -1) AND (LAST_KEY=-1) THEN
PLAY_PIP
IF KEY_FETCH<48 THEN LEFT_PART=LEFT_PART + MID$(KEYS,KEY_FETCH+1,1)
IF (KEY_FETCH\12)=5 THEN LEFT_PART=LEFT_PART + " "
IF ((KEY_FETCH\12)=6) AND (LEN(LEFT_PART) > 0) THEN LEFT_PART=LEFT$(LEFT_PART,LEN(LEFT_PART)-1)
IF (KEY_FETCH\12)=7 THEN DONE=1
IF (KEY_FETCH\12)=4 THEN
SHIFT_STATE=1 - SHIFT_STATE
IF SHIFT_STATE > 0 THEN KEYS=KEYS_UPPER ELSE KEYS=KEYS_LOWER
DRAW_KEYS(SHIFT_STATE)
ELSE
DRAW_KEY(KEY_FETCH,1)
ENDIF
LAST_KEY=KEY_FETCH
LEFT_TRIM=0
IF LEN(LEFT_PART)>14 THEN LEFT_TRIM=LEN(LEFT_PART)-14
TEXT 8,54,LEFT$(MID$(LEFT_PART,LEFT_TRIM+1)+PAD,14),LT,8,2,C.F,C.B
LINE 456,54,456,100,2,C.B
END IF
IF (KEY_FETCH<> LAST_KEY) AND (LAST_KEY<> -1) THEN
DRAW_KEY(LAST_KEY,0)
LAST_KEY=KEY_FETCH
END IF
CURSOR_POS=len(LEFT_PART)-LEFT_TRIM
IF ((TIMER \ 500) MOD 2) > 0 THEN
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.F
ELSE
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.B
ENDIF
IDLE(20)
IF DONE > 0 THEN
DO WHILE TOUCH(X)>-1
IDLE(50)
LOOP
DRAW_KEY(84,0)
IDLE(50)
LINE 8+CURSOR_POS*32,54,8+CURSOR_POS*32,100,2,C.B
ENDIF
IF LEN(LEFT_PART)>64 THEN LEFT_PART=lEFT$(LEFT_PART,64)
LOOP
KEYBOARD_STRING=LEFT_PART
END FUNCTION
SUB DRAW_KEYS(SHIFT AS INTEGER)
LOCAL X,Y AS INTEGER
IF SHIFT > 0 THEN KEYS=KEYS_UPPER ELSE KEYS=KEYS_LOWER
FOR Y=0 to 3
FOR X=0 TO 11
DRAW_KEY(X+Y*12,0)
NEXT X
NEXT Y
DRAW_KEY(48,0)
DRAW_KEY(60,0)
DRAW_KEY(72,0)
DRAW_KEY(84,0)
END SUB
SUB DRAW_KEY(N AS INTEGER,PRESSED AS INTEGER)
LOCAL INTEGER F,B
LOCAL INTEGER X,Y
X=N MOD 12
Y=N \ 12
IF PRESSED > 0 THEN
F=C.B
B=C.F
ELSE
F=C.F
B=C.B
ENDIF
IF X<0 OR X>11 OR Y<0 OR Y>3 OR (Y=2 AND X>10) THEN
IF Y=4 THEN BOX 0,280,98,38,1,F,B:TEXT 50,300,"SHIFT",CM,8,1,F,B
IF Y=5 THEN BOX 100,280,198,38,1,F,B:TEXT 200,300,"SPACE",CM,8,1,F,B
IF Y=6 THEN BOX 300,280,78,38,1,F,B:TEXT 340,300,"<--",CM,8,1,F,B
IF Y=7 THEN BOX 380,280,98,38,1,F,B:TEXT 430,300,"ENTER",CM,8,1,F,B
ELSE
IF Y=2 THEN
BOX X*40+20,Y*40+120,38,38,1,F,B
TEXT X*40+40,Y*40+140,MID$(KEYS,Y*12+X+1,1),CM,8,1,F,B
ELSE
BOX X*40,Y*40+120,38,38,1,F,B
TEXT X*40+20,Y*40+140,MID$(KEYS,Y*12+X+1,1),CM,8,1,F,B
ENDIF
ENDIF
END SUB
FUNCTION GET_KEY(SHIFT AS INTEGER) AS INTEGER
LOCAL INTEGER X,Y
X=TOUCH(X)
Y=TOUCH(Y)
GET_KEY=-1
IF Y>120 AND Y<160 THEN GET_KEY=X\40:EXIT FUNCTION
IF Y>160 AND Y<200 THEN GET_KEY=X\40 +12:EXIT FUNCTION
IF Y>200 AND Y<240 THEN GET_KEY=(X+20)\40 +23:EXIT FUNCTION
IF Y>240 AND Y<280 THEN GET_KEY=X\40 +36:EXIT FUNCTION
IF Y>280 THEN
IF X>0 AND X<100 THEN GET_KEY=48:EXIT FUNCTION
IF X>100 AND X<300 THEN GET_KEY=60:EXIT FUNCTION
IF X>300 AND X<380 THEN GET_KEY=72:EXIT FUNCTION
IF X>380 AND X<480 THEN GET_KEY=84:EXIT FUNCTION
ENDIF
END FUNCTION
FUNCTION ACCEPT_STRING(S AS STRING) AS INTEGER
ACCEPT_STRING=0
LOCAL INTEGER DONE,W,C
DONE=0
W=270
IF LEN(S)> 16 THEN W=LEN(S)*16+20
IF W>470 THEN W=470
BOX (480-W)\2,110,W,150,3,C.WARN,C.B
TEXT 240,120,"Accept?",CT,8,2,C.F,C.B
TEXT 240,175,LEFT$(S,29),CT,8,1,C.F,C.B
DRAWBUTTON(1,0,120,210,110,35,"OK")
DRAWBUTTON(0,0,250,210,110,35,"CANCEL")
PLAY_BELL
DO WHILE (DONE=0)
IDLE(20)
C=CHECKBUTTON(0,1)
IF C>-1 THEN
CHECKRELEASE(C)
DONE=1
ACCEPT_STRING=C
ENDIF
LOOP
END FUNCTION
SUB MESSAGE_BOX(S AS STRING) AS INTEGER
LOCAL INTEGER DONE,W
DONE=0
W=270
IF LEN(S)> 16 THEN W=LEN(S)*16+20
IF W>470 THEN W=470
BOX (480-W)\2,110,W,150,3,C.WARN,C.B
TEXT 240,120,"Message:",CT,8,2,C.F,C.B
TEXT 240,175,LEFT$(S,29),CT,8,1,C.F,C.B
DRAWBUTTON(0,0,185,210,110,35,"OK")
PLAY_BELL
DO WHILE (DONE=0)
IDLE(20)
IF CHECKBUTTON(0,0)>-1 THEN
CHECKRELEASE(0)
DONE=1
ENDIF
LOOP
END SUB
SUB DRAWBUTTON(N AS INTEGER,MODE AS INTEGER,X AS INTEGER,Y AS INTEGER,W AS INTEGER,H AS INTEGER,S AS STRING)
LOCAL INTEGER FNT
FNT=8
IF MODE=0 THEN
B_COORD(N,0)=X
B_COORD(N,1)=Y
B_COORD(N,2)=W
B_COORD(N,3)=H
BUTTON_TEXT(N)=S
ENDIF
IF B_COORD(N,2)<LEN(BUTTON_TEXT(N))*16+8 THEN FNT=1
IF MODE=2 THEN
BOX B_COORD(N,0),B_COORD(N,1),B_COORD(N,2),B_COORD(N,3),2,C.B,C.BUTTON
TEXT B_COORD(N,0)+B_COORD(N,2)\2,B_COORD(N,1)+B_COORD(N,3)\2,BUTTON_TEXT(N),CM,FNT,1,C.B,C.BUTTON
ENDIF
IF (MODE=1) OR (MODE=0) THEN
BOX B_COORD(N,0),B_COORD(N,1),B_COORD(N,2),B_COORD(N,3),2,C.BUTTON,C.B
TEXT B_COORD(N,0)+B_COORD(N,2)\2,B_COORD(N,1)+B_COORD(N,3)\2,BUTTON_TEXT(N),CM,FNT,1,C.BUTTON,C.B
ENDIF
END SUB
FUNCTION CHECKBUTTON(N0 AS INTEGER,N1 AS INTEGER) AS INTEGER
LOCAL INTEGER X,Y,N
CHECKBUTTON=-1
X=TOUCH(X)
Y=TOUCH(Y)
IF X<0 THEN EXIT FUNCTION
FOR N=N0 TO N1
IF X>B_COORD(N,0) AND X<B_COORD(N,0)+B_COORD(N,2) AND Y>B_COORD(N,1) AND Y<B_COORD(N,1)+B_COORD(N,3) THEN
CHECKBUTTON=N
ENDIF
NEXT N
IF CHECKBUTTON > -1 THEN DRAWBUTTON(CHECKBUTTON,2)
END FUNCTION
SUB CHECKRELEASE(N AS INTEGER)
PLAY_PIP
DO WHILE CHECKBUTTON(N,N)=N
IDLE_IGNORE_TOUCH(20)
LOOP
DRAWBUTTON(N,1)
IDLE_IGNORE_TOUCH(20)
END SUB
SUB SET_MCP4251(CHANNEL AS INTEGER,VALUE AS INTEGER)
LOCAL INTEGER JUNK,DATA_OUT
DATA_OUT=VALUE
IF DATA_OUT<0 THEN DATA_OUT=0
IF DATA_OUT>256 THEN DATA_OUT=256
IF CHANNEL>0 THEN DATA_OUT=DATA_OUT+4096
SPI OPEN 200000,3,16
pin(MCP4251_CS)=0
JUNK=SPI(DATA_OUT)
pin(MCP4251_CS)=1
SPI CLOSE
END SUB
SUB SET_VOLUME(VALUE AS INTEGER)
SET_MCP4251(0,VALUE)
SET_MCP4251(1,VALUE)
END SUB
SUB GET_BATTERY
SUPPLY_VOLTAGE=PIN(BAT_PIN)*2
END SUB
Function atan2(y As float,x As float) As float
If x > 0 Then atan2=Atn(y / x)
If x<0 And y >=0 Then atan2=Atn(y  /x) + Pi
If x=0 And y > 0  Then atan2=Pi / 2
If x<0 And y<0  Then atan2=Atn(y / x) - Pi
If x=0 And y<0  Then atan2=-Pi / 2
End Function
SUB PLAY_BELL
PLAY_AUDIO(PEEK(VARADDR BELL()))
END SUB
SUB PLAY_PIP
PLAY_AUDIO(peek(cfunaddr CLICK))
END SUB
SUB PLAY_AUDIO(PTR AS INTEGER)
IF COMBINED(AUDIO_GET_STATE)=0 AND SND_ON>0 THEN
JUNK=COMBINED(AUDIO_SET_PTR,PTR)
JUNK=COMBINED(AUDIO_PLAY)
ENDIF
END SUB
SUB PLAY_LPC(PTR AS INTEGER)
IF COMBINED(AUDIO_GET_STATE)=0 AND SND_ON>0 THEN
JUNK=COMBINED(AUDIO_LPC_PTR,PTR)
JUNK=COMBINED(AUDIO_LPC_START)
ENDIF
END SUB
SUB SET_GNSS
GPRMC_PARSE(0)=GNSS+"RMC"
GPGSA_PARSE(0)=GNSS+"GSA"
GPGSV_PARSE(0)=GNSS+"GSV"
GPGGA_PARSE(0)=GNSS+"GGA"
END SUB